<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        // Helper to create index if it does not already exist (MySQL only)
        $createIfMissing = function (string $table, string $indexName, string $columnsSql) {
            $exists = DB::table('information_schema.STATISTICS')
                ->whereRaw('TABLE_SCHEMA = DATABASE()')
                ->where('TABLE_NAME', $table)
                ->where('INDEX_NAME', $indexName)
                ->exists();
            if (!$exists) {
                DB::statement("CREATE INDEX `$indexName` ON `$table` ($columnsSql)");
            }
        };

        if (Schema::hasTable('transactions')) {
            $createIfMissing('transactions', 'idx_txn_business_type_date', 'business_id, type, transaction_date');
            $createIfMissing('transactions', 'idx_txn_business_type_status', 'business_id, type, status');
            $createIfMissing('transactions', 'idx_txn_business_type_payment', 'business_id, type, payment_status');
            $createIfMissing('transactions', 'idx_txn_location', 'location_id');
            $createIfMissing('transactions', 'idx_txn_contact', 'contact_id');
            $createIfMissing('transactions', 'idx_txn_created_by', 'created_by');
            if (Schema::hasColumn('transactions', 'purchase_mode')) {
                $createIfMissing('transactions', 'idx_txn_purchase_mode', 'purchase_mode');
            }
        }

        if (Schema::hasTable('transaction_payments')) {
            $createIfMissing('transaction_payments', 'idx_tp_transaction_isreturn', 'transaction_id, is_return');
            $createIfMissing('transaction_payments', 'idx_tp_transaction', 'transaction_id');
        }

        if (Schema::hasTable('contacts')) {
            $createIfMissing('contacts', 'idx_contacts_business_type', 'business_id, type');
        }
    }

    public function down(): void
    {
        // Intentionally leave indexes in place; removing can be disruptive.
    }
};

